/*--------------------------------------------------------------*
 *	UniMate Drive Value Added API Sample
 *	2015-04-13
 *--------------------------------------------------------------*/

#include "Value_Added_API.h"

#if (defined(_WIN32) || defined(_WIN64))
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAXLEN  1020

CALLBACKFUNC pfnCallback;

/* Callback function to show the processing
 */
int outputMsg(unsigned long Type, unsigned long position)
{
	printf("\rCurrent type %08x, position %d.%d%%%",Type, position/10, position%10);
	return 0;
}
void getCapacity()
{
	UMD_HANDLE handle[32];
	unsigned long deviceCount = 0;
	UMD_RV ret;
	unsigned long capacity, cdsizeRead, disksizeRead;

	/* Get list of slots containing UniMate Drive
	 */
	ret = UMD_Find(handle, &deviceCount); 
	if (ret == 0 && deviceCount > 0)
	{
		/* Get the Capacity of the first UniMate Drive
		 */
		ret = UMD_GetCapacity(handle[0], &capacity);
		if(ret != 0)
		{
			printf("	UMD_GetCapacity returned:		%08x\n\n", ret);
		}
		else
		{
			printf("	Capacity = %d MB\n",capacity);
		}

		/* Get the CD & Normal Disk Size of the first UniMate Drive
		 */
		ret = UMD_GetPartition(handle[0], &cdsizeRead, &disksizeRead);
		if(ret != 0)
		{
			printf("	UMD_GetPartitionTable returned:		%08x\n\n", ret);
		}
		else
		{
			printf("	cdsize = %dMB, disksize = %dMB\n", cdsizeRead, disksizeRead);
		}
	}
	else if(deviceCount == 0)
	{
		printf("No UniMate Drive is available.\n");
	}
	printf("\n");
	return;
}
void partition()
{
	UMD_HANDLE handle[32];
	unsigned long deviceCount = 0;
	UMD_RV ret;
	unsigned long cdsize, disksize;
	unsigned long cdsizeRead, disksizeRead;
	
	/* Set the callback function
	 */
	pfnCallback = outputMsg;

	/* Get list of slots containing UniMate Drive
	 */
	ret = UMD_Find(handle, &deviceCount); 
	if (ret == 0 && deviceCount > 0)
	{		
		printf("Input CD Partition Size(MB):\n");
		scanf("%d", &cdsize);
		printf("Input Disk Partition Size(MB):\n");
		scanf("%d", &disksize);

		/* Set the CD & Normal Disk Size of the first UniMate Drive
		 */
		ret = UMD_SetPartition(handle[0], cdsize, disksize);
		if(ret != 0)
		{
			printf("\n	UMD_SetPartitionTable returned:		%08x\n\n", ret);
		}
		else
		{
			printf("\n	UMD_SetPartitionTable Successed\n\n");
		}

		/* Get the CD & Normal Disk Size of the first UniMate Drive
		 * to check the setting
		 */
		ret = UMD_GetPartition(handle[0], &cdsizeRead, &disksizeRead);
		if(ret != 0)
		{
			printf("	UMD_GetPartitionTable returned:		%08x\n\n", ret);
		}
		else
		{
			printf("	UMD_GetPartitionTable Successed\n");
			printf("	cdsize = %dMB, disksize = %dMB\n", cdsizeRead, disksizeRead);
		}
	}
	else if(deviceCount == 0)
	{
		printf("No UniMate Drive is available.\n");
	}
	printf("\n");
	return;
}
void writeISO()
{
	UMD_HANDLE handle[32];
	unsigned long deviceCount = 0;
	UMD_RV ret;
	char fileName[MAXLEN];
	
	/* Set the callback function
	 */
	pfnCallback = outputMsg;

	/* Get list of slots containing UniMate Drive
	 */
	ret = UMD_Find(handle, &deviceCount); 
	if (ret == 0 && deviceCount > 0)
	{
		printf("Input ISO File:\n");
		scanf("%s", fileName);
		
		/* Write the iso file to the CD Partition of the first UniMate Drive
		 */
		ret = UMD_WriteISO(handle[0], fileName);
		if(ret != 0)
		{
			printf("\n	UMD_WriteISOFile returned:		%08x\n", ret);
		}
		else
		{
			printf("\n	UMD_WriteISOFile Successed\n");
		}
	}
	else if(deviceCount == 0)
	{
		printf("No UniMate Drive is available.\n");
	}
	printf("\n");
	return;
}


int main(int argc, int* argv[])
{
	int userSelect;

	while(1) 
	{
		printf("---------UniMate Drive Value Added Sample---------\n");
		printf("1: Get Total Capacity\n");
		printf("2: Partition\n");
		printf("3: Write ISO File\n");
		printf("0: exit\n");
		printf("----------------------------------------------\n");
		printf("Input Select:");
		scanf("%d", &userSelect);
		printf("\n");
		switch (userSelect)
		{
		case 0:
			printf("***********************Finished***********************\n");
			return 0;

		case 1:
			getCapacity();
			break;

		case 2:
			partition();
			break;

		case 3:
			writeISO();
			break;

		}
	};

	return 0;
}